from django.db import models
from django.contrib.auth.models import AbstractBaseUser,BaseUserManager





class UserManager(BaseUserManager):
    def create_user(self,username,first_name,last_name,age,disease,address,phone,password):
        if not username:
            raise ValueError('Enter Your Email')
            
        if not phone:
            raise ValueError('Enter Your phone')

        if not disease:
            raise ValueError('Enter Your disease')

        user = self.model(username=username,first_name=first_name,last_name=last_name,age=age,disease=disease,address=address,phone=phone)
        user.set_password(password)
        user.save(using = self._db)
        return user

    def create_superuser(self,username,first_name,last_name,age,disease,address,phone,password):
        user = self.create_user(username,first_name,last_name,age,disease,address,phone,password)
        user.is_admin = True
        user.save(using=self._db)
        return user


class User(AbstractBaseUser):
    username = models.CharField(verbose_name=("username"),max_length=50,unique=True)
    first_name = models.CharField(max_length=50)
    last_name = models.CharField(max_length=50)
    age     = models.CharField(verbose_name=("Age")     , max_length=200, null=True)
    disease = models.CharField(verbose_name=("Disease") , max_length=200, null=True)
    address = models.CharField(verbose_name=("Address") , max_length=200, null=True)
    phone = models.CharField(max_length=100,verbose_name=("phone"), null=True)
    is_active = models.BooleanField(default=True)
    is_admin = models.BooleanField(default=False)
    USERNAME_FIELD ='username'
    REQUIRED_FIELDS = ['first_name','last_name','age','disease','address','phone']
    objects = UserManager()

    def __str__(self):
        return self.username


    def has_perm(self,perm,obj=None):
        return True

    def has_module_perms(self,app_lable):
        return True

    @property
    def is_staff(self):
        return self.is_admin    